# Hoe VPS1 koppelen aan Git? - Snelle Gids

## 🎯 Het Probleem

VPS1 moet weten **waar** de Git repository staat om eraan te koppelen.

## ✅ Oplossing: 3 Methoden

---

## Methode 1: GitHub/GitLab Repository (Aanbevolen) ⭐

### Wat moet VPS2 doen:

1. **Maak een repository aan** op GitHub/GitLab/Bitbucket
2. **Voeg remote toe** op VPS2:
   ```bash
   cd /var/www/html
   git remote add origin https://github.com/jouw-username/monorepo.git
   git push -u origin master
   ```
3. **Geef de URL door** aan VPS1

### Wat moet VPS1 doen:

```bash
cd /var/www/html
git clone https://github.com/jouw-username/monorepo.git .
# Of als je al code hebt:
git init
git remote add origin https://github.com/jouw-username/monorepo.git
git pull origin master
```

**Voordelen:**
- ✅ Makkelijk te gebruiken
- ✅ Altijd beschikbaar
- ✅ Geschiedenis bewaard
- ✅ Werkt vanaf elke locatie

---

## Methode 2: Direct van VPS2 (Backup Bestand)

### Wat moet VPS2 doen:

```bash
cd /var/www/html
tar -czf monorepo-backup.tar.gz .git Oraviare/ README.md SETUP.md MONOREPO_UITLEG.md VOOR_VPS1_ADALYAPOINT.md .gitignore
```

Upload dit bestand naar VPS1 (via SCP, FTP, of web server).

### Wat moet VPS1 doen:

```bash
cd /var/www/html
# Upload monorepo-backup.tar.gz hierheen, dan:
tar -xzf monorepo-backup.tar.gz
git status  # Check of het werkt
```

**Voordelen:**
- ✅ Geen GitHub/GitLab nodig
- ✅ Direct van VPS2

**Nadelen:**
- ❌ Handmatig proces
- ❌ Geen automatische sync (moet handmatig opnieuw doen)

---

## Methode 3: SSH Direct tussen VPS'en

### Wat moet VPS2 doen:

1. **Maak SSH key aan** (als nog niet bestaat):
   ```bash
   ssh-keygen -t rsa -b 4096
   ```

2. **Geef publieke key** aan VPS1 (voeg toe aan `~/.ssh/authorized_keys`)

### Wat moet VPS1 doen:

```bash
cd /var/www/html
git init
git remote add vps2 ssh://user@vps2-ip:/var/www/html/.git
git pull vps2 master
```

**Voordelen:**
- ✅ Direct tussen servers
- ✅ Geen tussenpersoon nodig

**Nadelen:**
- ❌ SSH configuratie nodig
- ❌ Complexer opzetten

---

## 📋 Stap-voor-Stap: Meest Eenvoudige Methode

### Voor VPS2 (Obevaria):

```bash
# 1. Maak GitHub repository aan (via website)
# 2. Voeg remote toe:
cd /var/www/html
git remote add origin https://github.com/jouw-username/monorepo.git
git push -u origin master

# 3. Geef deze URL door aan VPS1:
# https://github.com/jouw-username/monorepo.git
```

### Voor VPS1 (Adalyapoint):

```bash
# 1. Krijg de URL van VPS2
# 2. Clone de repository:
cd /var/www/html
git clone https://github.com/jouw-username/monorepo.git .

# 3. Check of het werkt:
git status
# Je zou Oraviare/ moeten zien

# 4. Voeg je eigen code toe:
git add AdalyaPoint/
git commit -m "Add Adalyapoint (VPS1) codebase"
git push
```

---

## ❓ Welke Methode Kies Je?

| Methode | Moeilijkheid | Aanbevolen voor |
|---------|-------------|-----------------|
| GitHub/GitLab | ⭐ Eenvoudig | **Aanbevolen!** |
| Backup Bestand | ⭐⭐ Medium | Als geen GitHub |
| SSH Direct | ⭐⭐⭐ Complex | Geavanceerde gebruikers |

---

## 🆘 Hulp Nodig?

**Vraag aan VPS2:**
- "Heb je een GitHub/GitLab repository URL voor me?"
- "Of moet ik de backup methode gebruiken?"

**Als VPS2 zegt: "Ik weet niet hoe":**
- Gebruik Methode 2 (Backup Bestand) - dat is het makkelijkst zonder GitHub
