# Volgende Stappen voor Monorepo

## ✅ Wat is al gedaan:
- Git repo geïnitialiseerd op VPS2
- Obevaria code (Oraviare/) staat in de repo
- Website werkt weer

## 🎯 Wat moet nog gebeuren:

### Stap 1: Remote Git Repository instellen (Aanbevolen)

**Optie A: GitHub/GitLab/Bitbucket**
1. Maak een nieuwe repository aan op GitHub/GitLab
2. Voeg remote toe op VPS2:
   ```bash
   cd /var/www/html
   git remote add origin https://github.com/jouw-username/monorepo.git
   # Of met SSH:
   git remote add origin git@github.com:jouw-username/monorepo.git
   git push -u origin master
   ```

**Optie B: Direct tussen VPS'en (zonder remote)**
- Je kunt ook direct tussen VPS'en pushen, maar dit is complexer

### Stap 2: VPS1 (Adalyapoint) toevoegen

**Op VPS1, voer uit:**

```bash
# 1. Clone de repo (als je remote hebt gebruikt)
cd /var/www/html
git clone <repository-url> .

# OF als je al code hebt:
cd /var/www/html
git init
git remote add origin <repository-url>
git pull origin master

# 2. Verplaats Adalyapoint code (als die al bestaat)
# Als Adalyapoint in /var/www/html/AdalyaPoint/ staat:
# (niets doen, directory naam is al correct)

# 3. Voeg Adalyapoint toe aan Git
git add AdalyaPoint/
git commit -m "Add Adalyapoint (VPS1) codebase"
git push
```

### Stap 3: Test synchronisatie

**Op VPS2, maak een test wijziging:**
```bash
cd /var/www/html
echo "# Test" >> README.md
git add README.md
git commit -m "Test: synchronisatie"
git push
```

**Op VPS1, haal wijziging op:**
```bash
cd /var/www/html
git pull
```

## 📋 Snelle Checklist:

- [ ] Remote Git repository aanmaken (GitHub/GitLab)
- [ ] Remote toevoegen op VPS2 en pushen
- [ ] VPS1 koppelen aan dezelfde repo
- [ ] Adalyapoint code toevoegen aan monorepo
- [ ] Test: wijziging op VPS2, pull op VPS1

## ⚠️ Belangrijk:

- **Configuratie bestanden** (database.php, app.php) worden NIET gecommit
- Elke VPS heeft zijn eigen configuratie
- Test altijd eerst op één VPS voordat je pusht
