# VPS2 - Furniture Shop Dashboard

## Overzicht
VPS2 is de meubelwebshop die payment processing afhandelt voor VPS1 (Vape Webshop). Klanten bestellen vape producten op VPS1, maar betalingen worden verwerkt via VPS2 waarbij meubelproducten worden getoond aan de payment provider.

## Belangrijke Features

### API Endpoints

**Voor VPS1:**
- **POST /api/v1/orders/create** - Ontvangt orders van VPS1 en maakt furniture orders aan
- **GET /api/v1/orders/{id}/status** - Returnt payment status van furniture order
- **POST /api/v1/orders/{id}/payment-status** - Update payment status (van payment provider) en stuurt automatisch webhook naar VPS1

**Voor Monitoring:**
- **GET /api/v1/orders** - Lijst van alle orders met statistieken
- **GET /api/v1/orders/{id}** - Order details
- **POST /api/v1/orders/{id}/webhook** - Handmatig webhook versturen naar VPS1
- **POST /api/v1/webhooks/process** - Verwerk alle pending webhooks

### Database
- Database naam: `furniture_shop`
- Schema bestand: `database/vps2_schema.sql`
- Belangrijkste tabellen:
  - `furniture_orders` - Orders van VPS1 die hier verwerkt worden
  - `furniture_products` - Furniture producten die gekoppeld worden aan VPS1 producten
  - `api_credentials` - API keys voor VPS1 authenticatie
  - `api_access_log` - Logging van alle API calls en webhooks

### Security
- HMAC signature verificatie (SHA256)
- API key authenticatie
- API call logging

## Setup Instructies

### 1. Database Setup
```sql
-- Importeer database schema in phpMyAdmin
SOURCE database/vps2_schema.sql;
```

### 2. Configuratie
De configuratie staat in:
- `config/app.php` - App configuratie (URL, timezone, etc.)
- `config/database.php` - Database connectie instellingen

**Belangrijk**: Pas de database naam aan in `config/database.php` als nodig.

### 3. API Credentials
Maak API credentials aan in database:
```sql
UPDATE api_credentials 
SET api_key = 'YOUR_API_KEY', 
    api_secret = 'YOUR_API_SECRET',
    webhook_secret = 'YOUR_WEBHOOK_SECRET'
WHERE id = 1;
```

### 4. Access
- API endpoints: `http://localhost/vps2-dashboard/public/api/v1/...`
- Root URL: `http://localhost/vps2-dashboard/public/`

## Order Flow

1. **VPS1** - Klant bestelt vape product
2. **VPS1** - Kijkt in product_mappings voor gekoppeld furniture product
3. **VPS1** - Stuurt order naar VPS2 via `POST /api/v1/orders/create`
4. **VPS2** - Maakt furniture order aan in database
5. **VPS2** - Genereert payment URL en stuurt terug naar VPS1
6. **VPS1** - Redirect klant naar payment URL (op VPS2 domein)
7. **VPS2** - Klant betaalt via payment provider (ziet furniture product)
8. **VPS2** - Payment provider stuurt webhook naar VPS2
9. **VPS2** - Update payment status en stuurt automatisch webhook naar VPS1
10. **VPS1** - Update order status naar "paid"
11. **VPS1** - Stuurt bevestigingsmail naar klant over vape product

## Belangrijke Bestanden

### Controllers
- `app/Controllers/OrderApiController.php` - API endpoints voor VPS1

### Models
- `app/Models/FurnitureOrder.php` - Furniture orders model
- `app/Models/FurnitureProduct.php` - Furniture producten model
- `app/Models/ApiCredential.php` - API credentials model

### Services
- `app/Services/WebhookService.php` - Service om payment updates naar VPS1 te sturen

### Database
- `database/vps2_schema.sql` - Database schema

## API Authenticatie

VPS1 moet de volgende headers meesturen:
```
X-API-Key: {api_key}
X-Signature: {hmac_signature}
```

De signature wordt berekend met:
```
signature = HMAC-SHA256(request_body, api_secret)
```

## Belangrijke Features

✅ **Product Management** - Furniture producten kunnen beheerd worden
✅ **Order Processing** - Orders van VPS1 worden opgeslagen en verwerkt
✅ **Automatic Webhooks** - Bij payment status updates wordt automatisch webhook naar VPS1 gestuurd
✅ **Webhook Retry Logic** - Automatische retry bij gefaalde webhooks
✅ **API Logging** - Alle API calls worden gelogd
✅ **Monitoring Endpoints** - Orders kunnen gemonitord worden via API

## TODO (Nog te implementeren)

- [ ] Payment provider integratie (Mollie, Stripe, etc.)
- [ ] Checkout pagina voor payment URL
- [ ] Payment provider webhook handler endpoint
- [ ] IP whitelist functionaliteit
- [ ] Rate limiting
- [ ] Admin dashboard UI (optioneel)

## Notities

- VPS2 stuurt GEEN emails naar klanten (dat doet VPS1)
- VPS2 handelt alleen payment processing af
- Alle klantcommunicatie gebeurt via VPS1
- API keys worden NIET encrypted opgeslagen (voor nu)

