<?php
namespace App\Controllers;

use Core\Controller;
use App\Models\User;

/**
 * AuthController
 * Authenticatie voor admin dashboard
 */
class AuthController extends Controller
{
    private User $userModel;

    public function __construct()
    {
        parent::__construct();
        $this->userModel = new User();
    }

    /**
     * Login formulier
     */
    public function loginForm(): void
    {
        if ($this->isAuthenticated()) {
            $this->redirect('/dashboard');
            return;
        }

        $this->view('auth.login', [
            'title' => 'Login - VPS2 Dashboard'
        ]);
    }

    /**
     * Login verwerken
     */
    public function login(): void
    {
        $username = $this->request->post('username');
        $password = $this->request->post('password');

        if (empty($username) || empty($password)) {
            $this->flash('error', 'Vul alle velden in.');
            $this->back();
            return;
        }

        $user = $this->userModel->findByUsername($username);

        if (!$user) {
            $this->flash('error', 'Ongeldige gebruikersnaam of wachtwoord.');
            $this->back();
            return;
        }

        // Verifieer password
        if (!password_verify($password, $user['password'])) {
            $this->flash('error', 'Ongeldige gebruikersnaam of wachtwoord.');
            $this->back();
            return;
        }

        // Login succesvol
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_data'] = $user;

        $this->redirect('/dashboard');
    }

    /**
     * Uitloggen
     */
    public function logout(): void
    {
        session_destroy();
        $this->redirect('/login');
    }
}

