<?php
namespace App\Models;

use Core\Model;

/**
 * User Model
 * Beheert gebruikers voor admin dashboard
 */
class User extends Model
{
    protected string $table = 'users';

    /**
     * Gebruiker ophalen op username
     */
    public function findByUsername(string $username): ?array
    {
        return $this->where('username', $username);
    }

    /**
     * Gebruiker ophalen op email
     */
    public function findByEmail(string $email): ?array
    {
        return $this->where('email', $email);
    }
}

