<div class="category-form-wrapper">
    <div class="form-header">
        <h2>Nieuwe Categorie Toevoegen</h2>
        <p>Voeg een nieuwe product categorie toe</p>
    </div>

    <form method="POST" action="<?= url('/dashboard/categories/create') ?>" class="category-form">
        <?= csrf_field() ?>

        <div class="form-section">
            <div class="form-group">
                <label for="name">Categorienaam *</label>
                <input 
                    type="text" 
                    id="name" 
                    name="name" 
                    class="form-control"
                    placeholder="Bijv. Stoelen"
                    required
                >
                <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                    Naam van de categorie
                </small>
            </div>

            <div class="form-group">
                <label for="description">Beschrijving</label>
                <textarea 
                    id="description" 
                    name="description" 
                    class="form-control"
                    rows="4"
                    placeholder="Optionele beschrijving van de categorie..."
                ></textarea>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label for="sort_order">Sorteervolgorde</label>
                    <input 
                        type="number" 
                        id="sort_order" 
                        name="sort_order" 
                        class="form-control"
                        value="0"
                        min="0"
                    >
                    <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                        Lagere getallen worden eerder getoond
                    </small>
                </div>

                <div class="form-group col-md-6">
                    <label for="status">Status</label>
                    <select id="status" name="status" class="form-control">
                        <option value="active" selected>Actief</option>
                        <option value="inactive">Inactief</option>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-actions">
            <a href="<?= url('/dashboard/categories') ?>" class="btn btn-secondary">
                <i class="fas fa-times"></i> Annuleren
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> Categorie Opslaan
            </button>
        </div>
    </form>
</div>

<style>
.category-form-wrapper {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    overflow: hidden;
}

.form-header {
    padding: 1.5rem;
    border-bottom: 1px solid #e2e8f0;
    background: #f8fafc;
}

.form-header h2 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #0f172a;
    margin: 0 0 0.25rem 0;
}

.form-header p {
    font-size: 0.875rem;
    color: #64748b;
    margin: 0;
}

.category-form {
    padding: 1.5rem;
}

.form-section {
    margin-bottom: 1.5rem;
}

.form-group {
    margin-bottom: 1.5rem;
}

.form-group label {
    display: block;
    font-size: 0.875rem;
    font-weight: 600;
    color: #0f172a;
    margin-bottom: 0.5rem;
}

.form-control {
    width: 100%;
    padding: 0.625rem 0.875rem;
    font-size: 0.875rem;
    line-height: 1.5;
    color: #0f172a;
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}

.form-control:focus {
    outline: none;
    border-color: #ea580c;
    box-shadow: 0 0 0 3px rgba(234, 88, 12, 0.1);
}

.form-row {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.form-row .col-md-6 {
    flex: 1;
    min-width: 250px;
}

.form-actions {
    display: flex;
    gap: 1rem;
    justify-content: flex-end;
    padding-top: 1.5rem;
    border-top: 1px solid #e2e8f0;
}
</style>
