<!-- Page Actions Bar -->
<div class="page-actions-bar">
    <div class="page-description">
        <p>Beheer product categorieën</p>
    </div>
    <div class="page-actions">
        <a href="<?= url('/dashboard/categories/create') ?>" class="btn btn-primary">
            <i class="fas fa-plus"></i>
            <span>Nieuwe Categorie</span>
        </a>
    </div>
</div>

<div class="categories-section">
    <div class="categories-header">
        <h3>Alle Categorieën</h3>
    </div>
    <?php if (!empty($categories)): ?>
        <div class="table-responsive">
            <table class="table categories-table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Naam</th>
                        <th>Slug</th>
                        <th>Beschrijving</th>
                        <th>Producten</th>
                        <th>Volgorde</th>
                        <th>Status</th>
                        <th>Acties</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($categories as $category): ?>
                        <tr>
                            <td>#<?= e($category['id']) ?></td>
                            <td>
                                <strong><?= e($category['name']) ?></strong>
                            </td>
                            <td>
                                <code><?= e($category['slug']) ?></code>
                            </td>
                            <td>
                                <?= e($category['description'] ?? '-') ?>
                            </td>
                            <td>
                                <span class="badge badge-info">
                                    <?= (int)($category['product_count'] ?? 0) ?>
                                </span>
                            </td>
                            <td><?= (int)($category['sort_order'] ?? 0) ?></td>
                            <td>
                                <span class="badge badge-<?= $category['status'] === 'active' ? 'success' : 'secondary' ?>">
                                    <?= $category['status'] === 'active' ? 'Actief' : 'Inactief' ?>
                                </span>
                            </td>
                            <td class="table-actions">
                                <div style="display: inline-flex; align-items: center; gap: 0.375rem;">
                                    <a href="<?= url('/dashboard/categories/edit/' . $category['slug']) ?>" 
                                       class="btn btn-sm btn-primary" 
                                       title="Bewerken">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <form method="POST" 
                                          action="<?= url('/dashboard/categories/delete/' . $category['slug']) ?>" 
                                          style="display: inline-flex; align-items: center; margin: 0;" 
                                          onsubmit="return confirm('Weet je zeker dat je deze categorie wilt verwijderen?');">
                                        <?= csrf_field() ?>
                                        <button type="submit" class="btn btn-sm btn-danger" title="Verwijderen">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="categories-empty">
            <i class="fas fa-folder-open"></i>
            <div class="categories-empty-content">
                <p class="categories-empty-title">Geen categorieën gevonden</p>
                <p class="categories-empty-text">Voeg je eerste categorie toe om te beginnen.</p>
                <a href="<?= url('/dashboard/categories/create') ?>" class="btn btn-primary btn-sm">
                    <i class="fas fa-plus"></i> Nieuwe Categorie
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
