<?php
// View wordt geladen via public.php layout
?>

<div class="checkout-result">
    <div class="result-icon success">
        <i class="fas fa-check-circle"></i>
    </div>
    <h1>Betaling voltooid!</h1>
    <p>Uw betaling is succesvol verwerkt.</p>
    <div class="order-info">
        <p><strong>Ordernummer:</strong> <?= htmlspecialchars($order['external_order_id']) ?></p>
        <p><strong>Bedrag:</strong> €<?= number_format($order['price'], 2, ',', '.') ?></p>
        <p><strong>Status:</strong> <span class="status-paid">Betaald</span></p>
    </div>
    <div class="result-actions">
        <a href="<?= url('/') ?>" class="btn btn-secondary">
            <i class="fas fa-home"></i> Terug naar home
        </a>
    </div>
</div>

<style>
.checkout-result {
    max-width: 600px;
    margin: 4rem auto;
    text-align: center;
    background: white;
    padding: 3rem;
    border-radius: 12px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
}

.result-icon {
    width: 80px;
    height: 80px;
    margin: 0 auto 2rem;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2.5rem;
}

.result-icon.success {
    background: #dcfce7;
    color: #16a34a;
}

.checkout-result h1 {
    margin: 0 0 1rem 0;
    font-size: 2rem;
    color: #0f172a;
}

.checkout-result > p {
    color: #64748b;
    margin-bottom: 2rem;
    font-size: 1.125rem;
}

.order-info {
    background: #f8fafc;
    padding: 1.5rem;
    border-radius: 8px;
    margin-bottom: 2rem;
    text-align: left;
}

.order-info p {
    margin: 0.75rem 0;
    color: #0f172a;
}

.status-paid {
    color: #16a34a;
    font-weight: 600;
}

.result-actions {
    display: flex;
    gap: 1rem;
    justify-content: center;
}

.btn {
    padding: 0.875rem 1.5rem;
    border-radius: 6px;
    font-size: 1rem;
    font-weight: 500;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    transition: all 0.2s;
}

.btn-secondary {
    background: #f1f5f9;
    color: #0f172a;
    border: 1px solid #e2e8f0;
}

.btn-secondary:hover {
    background: #e2e8f0;
}
</style>
