<!-- Statistieken Cards -->
<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-icon blue">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <div class="stat-details">
            <h3><?= number_format($stats['total_orders'] ?? 0) ?></h3>
            <p>Totaal Orders</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon orange">
            <i class="fas fa-clock"></i>
        </div>
        <div class="stat-details">
            <h3><?= number_format($stats['pending_orders'] ?? 0) ?></h3>
            <p>Pending Orders</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon green">
            <i class="fas fa-check-circle"></i>
        </div>
        <div class="stat-details">
            <h3><?= number_format($stats['paid_orders'] ?? 0) ?></h3>
            <p>Betaalde Orders</p>
        </div>
    </div>

    <div class="stat-card">
        <div class="stat-icon red">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <div class="stat-details">
            <h3><?= number_format($stats['pending_webhooks'] ?? 0) ?></h3>
            <p>Pending Webhooks</p>
        </div>
    </div>
</div>

<!-- Recente Orders -->
<div class="card" style="margin-top: 2rem;">
    <div class="card-header">
        <h3>Recente Orders</h3>
        <a href="<?= url('/dashboard/orders') ?>">Bekijk Alles →</a>
    </div>
    <div class="card-body">
        <?php if (!empty($stats['recent_orders'])): ?>
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Order ID</th>
                            <th>External Order</th>
                            <th>Product</th>
                            <th>Prijs</th>
                            <th>Status</th>
                            <th>Datum</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($stats['recent_orders'] as $order): ?>
                            <tr>
                                <td><a href="<?= url('/dashboard/orders/view/' . $order['furniture_order_id']) ?>"><?= e($order['furniture_order_id']) ?></a></td>
                                <td><?= e($order['external_order_id']) ?></td>
                                <td><?= e($order['product_name']) ?></td>
                                <td><?= format_price($order['price']) ?></td>
                                <td>
                                    <span class="badge badge-<?= $order['payment_status'] === 'paid' ? 'success' : ($order['payment_status'] === 'failed' ? 'error' : 'warning') ?>">
                                        <?= e($order['payment_status']) ?>
                                    </span>
                                </td>
                                <td><?= format_date($order['created_at']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p style="text-align: center; color: #64748b; padding: 2rem;">Nog geen orders ontvangen</p>
        <?php endif; ?>
    </div>
</div>

