<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Instellingen' ?> - Oraviare</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?= asset('css/style.css') ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <!-- Sidebar -->
    <aside class="sidebar">
        <div class="sidebar-header" style="text-align: center; padding: 1.5rem;">
            <h2 style="color: white; font-size: 1.25rem; margin: 0;">Oraviare</h2>
            <p style="color: rgba(255,255,255,0.7); font-size: 0.875rem; margin: 0.5rem 0 0 0;">Admin Dashboard</p>
        </div>
        
        <nav class="sidebar-nav">
            <a href="<?= url('/dashboard') ?>" class="nav-item">
                <i class="fas fa-chart-line"></i>
                <span>Dashboard</span>
            </a>
            
            <a href="<?= url('/dashboard/orders') ?>" class="nav-item">
                <i class="fas fa-shopping-cart"></i>
                <span>Orders</span>
            </a>
            
            <a href="<?= url('/dashboard/products') ?>" class="nav-item">
                <i class="fas fa-box"></i>
                <span>Producten</span>
            </a>
            
            <a href="<?= url('/dashboard/categories') ?>" class="nav-item">
                <i class="fas fa-folder"></i>
                <span>Categorieën</span>
            </a>
            
            <a href="<?= url('/dashboard/settings') ?>" class="nav-item active">
                <i class="fas fa-cog"></i>
                <span>Instellingen</span>
            </a>
            
            <a href="<?= url('/logout') ?>" class="nav-item logout">
                <i class="fas fa-sign-out-alt"></i>
                <span>Uitloggen</span>
            </a>
        </nav>
    </aside>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <header class="topbar">
            <div class="topbar-left">
                <h1><?= $title ?? 'Instellingen' ?></h1>
            </div>
            <div class="topbar-right">
                <div class="user-info">
                    <i class="fas fa-user-circle"></i>
                    <span><?= e($user['username'] ?? 'Gebruiker') ?></span>
                </div>
            </div>
        </header>

        <!-- Flash Messages -->
        <?php if ($success = flash('success')): ?>
            <div class="alert alert-success">
                <i class="fas fa-check-circle"></i>
                <?= e($success) ?>
            </div>
        <?php endif; ?>

        <?php if ($error = flash('error')): ?>
            <div class="alert alert-error">
                <i class="fas fa-exclamation-circle"></i>
                <?= e($error) ?>
            </div>
        <?php endif; ?>

        <!-- Page Content -->
        <div class="content-wrapper">
            <?php require __DIR__ . '/_settings.php'; ?>
        </div>
    </div>

    <script src="<?= asset('js/main.js') ?>"></script>
</body>
</html>
