<?php
// Laad helpers
require_once __DIR__ . '/../../../core/helpers.php';
?>
<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Checkout' ?> - Furniture Shop</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #f8fafc;
            color: #0f172a;
            line-height: 1.6;
            min-height: 100vh;
        }
    </style>
</head>
<body>
    <?php
    // Include de view content
    $viewPath = __DIR__ . '/../' . str_replace('.', '/', $contentView ?? 'checkout/show') . '.php';
    if (file_exists($viewPath)) {
        require $viewPath;
    } else {
        die("View niet gevonden: {$contentView}");
    }
    ?>
</body>
</html>
