<div class="page-header" style="display: flex; align-items: center; justify-content: space-between; margin-bottom: 2rem; padding-bottom: 1rem; border-bottom: 1px solid #e2e8f0;">
    <div style="display: flex; align-items: center; gap: 1rem;">
        <a href="<?= url('/dashboard/products') ?>" style="color: #64748b; text-decoration: none; font-size: 0.875rem; font-weight: 500; transition: color 0.2s;" onmouseover="this.style.color='#0f172a';" onmouseout="this.style.color='#64748b';">
            <i class="fas fa-arrow-left"></i> Terug
        </a>
        <span style="color: #cbd5e1;">|</span>
        <h1 style="font-size: 1.5rem; font-weight: 600; color: #0f172a; margin: 0;">Product Bewerken</h1>
    </div>
</div>

<div class="form-container">
    <form method="POST" action="<?= url('/dashboard/products/edit/' . $product['id']) ?>" class="product-form" enctype="multipart/form-data">
        <?= csrf_field() ?>

        <div class="card">
            <div class="card-header">
                <h3>Product Informatie</h3>
            </div>
            <div class="card-body">
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="product_id">Product ID *</label>
                        <input 
                            type="text" 
                            id="product_id" 
                            name="product_id" 
                            class="form-control"
                            value="<?= e($product['product_id']) ?>"
                            required
                            pattern="[A-Z0-9\-_]+"
                            title="Alleen hoofdletters, cijfers, streepjes en underscores"
                        >
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            Unieke identifier (bijv. STOEL-001, LAMP-DESIGN)
                        </small>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="name">Productnaam *</label>
                        <input 
                            type="text" 
                            id="name" 
                            name="name" 
                            class="form-control"
                            value="<?= e($product['name']) ?>"
                            required
                        >
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="sku">SKU</label>
                        <input 
                            type="text" 
                            id="sku" 
                            name="sku" 
                            class="form-control"
                            value="<?= e($product['sku'] ?? '') ?>"
                        >
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            Optioneel: Stock Keeping Unit
                        </small>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="category">Categorie</label>
                        <select 
                            id="category" 
                            name="category" 
                            class="form-control"
                        >
                            <option value="">Geen categorie</option>
                            <option value="Stoelen" <?= ($product['category'] ?? '') === 'Stoelen' ? 'selected' : '' ?>>Stoelen</option>
                            <option value="Tafels" <?= ($product['category'] ?? '') === 'Tafels' ? 'selected' : '' ?>>Tafels</option>
                            <option value="Lampen" <?= ($product['category'] ?? '') === 'Lampen' ? 'selected' : '' ?>>Lampen</option>
                            <option value="Kussens" <?= ($product['category'] ?? '') === 'Kussens' ? 'selected' : '' ?>>Kussens</option>
                            <option value="Vazen" <?= ($product['category'] ?? '') === 'Vazen' ? 'selected' : '' ?>>Vazen</option>
                            <option value="Decoratie" <?= ($product['category'] ?? '') === 'Decoratie' ? 'selected' : '' ?>>Decoratie</option>
                            <option value="Accessoires" <?= ($product['category'] ?? '') === 'Accessoires' ? 'selected' : '' ?>>Accessoires</option>
                        </select>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="price">Prijs *</label>
                        <input 
                            type="number" 
                            id="price" 
                            name="price" 
                            class="form-control"
                            step="0.01"
                            min="0"
                            value="<?= e($product['price']) ?>"
                            required
                        >
                    </div>

                    <div class="form-group col-md-4">
                        <label for="compare_price">Vergelijkingsprijs</label>
                        <input 
                            type="number" 
                            id="compare_price" 
                            name="compare_price" 
                            class="form-control"
                            step="0.01"
                            min="0"
                            value="<?= e($product['compare_price'] ?? '') ?>"
                        >
                        <small style="color: #64748b; font-size: 0.75rem; margin-top: 0.25rem; display: block;">
                            Originele prijs (voor korting weergave)
                        </small>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="currency">Currency</label>
                        <select 
                            id="currency" 
                            name="currency" 
                            class="form-control"
                        >
                            <option value="EUR" <?= ($product['currency'] ?? 'EUR') === 'EUR' ? 'selected' : '' ?>>EUR</option>
                            <option value="USD" <?= ($product['currency'] ?? 'EUR') === 'USD' ? 'selected' : '' ?>>USD</option>
                            <option value="GBP" <?= ($product['currency'] ?? 'EUR') === 'GBP' ? 'selected' : '' ?>>GBP</option>
                        </select>
                    </div>
                </div>

                <div class="form-group">
                    <label for="description">Beschrijving</label>
                    <div id="description-editor" style="min-height: 200px; border: 1px solid #e2e8f0; border-radius: 6px; background: #fff;"></div>
                    <textarea 
                        id="description" 
                        name="description" 
                        style="display: none;"
                    ><?= e($product['description'] ?? '') ?></textarea>
                </div>

                <div class="form-group">
                    <label for="images" class="form-label">Afbeeldingen</label>
                    
                    <input 
                        type="file" 
                        id="images" 
                        name="images[]" 
                        class="form-control file-input"
                        accept="image/*"
                        multiple
                        onchange="previewImages(this)"
                    >
                    <!-- Hidden input to track which new image should be primary (0-indexed) -->
                    <input type="hidden" id="new_primary_index" name="new_primary_index" value="">
                    
                    <div class="existing-images" style="margin-top: 1.5rem;">
                        <div class="images-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 1rem;">
                            <?php if (!empty($images)): ?>
                                <?php foreach ($images as $index => $img): ?>
                                    <div data-image-id="<?= $img['id'] ?>" data-set-primary-url="<?= url('/dashboard/products/set-primary-image/' . $img['id']) ?>" style="position: relative; border: 2px solid <?= $img['is_primary'] ? '#0f172a' : '#e2e8f0' ?>; border-radius: 6px; padding: 6px; background: <?= $img['is_primary'] ? '#f8fafc' : '#fff' ?>; transition: all 0.3s;">
                                        <div class="image-wrapper" style="position: relative; width: 100%; height: 140px; border-radius: 4px; overflow: hidden; border: 1px solid #e2e8f0;">
                                            <img src="<?= url('/' . $img['image_path']) ?>" 
                                                 alt="Product afbeelding <?= $index + 1 ?>" 
                                                 style="width: 100%; height: 100%; object-fit: cover; display: block;">
                                            
                                            <!-- Action buttons overlay -->
                                            <div style="position: absolute; top: 8px; left: 8px; z-index: 10;">
                                                <?php if ($img['is_primary']): ?>
                                                    <div class="primary-indicator" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;">
                                                        <i class="fas fa-check" style="font-size: 0.875rem;"></i>
                                                    </div>
                                                <?php else: ?>
                                                    <button type="button" 
                                                            class="primary-indicator set-primary-btn"
                                                            data-url="<?= url('/dashboard/products/set-primary-image/' . $img['id']) ?>"
                                                            data-image-id="<?= $img['id'] ?>"
                                                            style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent; position: relative; z-index: 100;" 
                                                            title="Maak hoofdfoto" 
                                                            onmouseover="this.style.background='#0f172a'; this.style.color='white'; this.style.borderColor='#0f172a'; this.querySelector('i').style.display='block';" 
                                                            onmouseout="this.style.background='rgba(255, 255, 255, 0.95)'; this.style.color='transparent'; this.style.borderColor='#e2e8f0'; this.querySelector('i').style.display='none';">
                                                        <i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                            
                                            <div style="position: absolute; top: 8px; right: 8px; z-index: 10;">
                                                <button type="button" 
                                                        class="delete-image-btn"
                                                        data-url="<?= url('/dashboard/products/delete-image/' . $img['id']) ?>"
                                                        data-image-id="<?= $img['id'] ?>"
                                                        style="width: 36px; height: 36px; border-radius: 50%; background: rgba(220, 38, 38, 0.95); border: 1px solid #dc2626; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: white; position: relative; z-index: 100;"
                                                        title="Verwijder afbeelding">
                                                    <i class="fas fa-trash" style="font-size: 0.75rem;"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="toggle-container">
                        <span class="toggle-label">Product is actief</span>
                        <label class="toggle-switch">
                            <input 
                                type="checkbox" 
                                name="is_active" 
                                value="1" 
                                <?= $product['is_active'] ? 'checked' : '' ?>
                                class="toggle-input"
                            >
                            <span class="toggle-slider"></span>
                        </label>
                    </div>
                    <small class="form-hint" style="margin-left: 0;">
                        Alleen actieve producten zijn zichtbaar voor VPS1
                    </small>
                </div>
            </div>
        </div>

        <div style="display: flex; gap: 1rem; margin-top: 2rem;">
            <button type="submit" class="btn btn-primary" style="flex: 0 0 auto;">
                <i class="fas fa-save"></i> Wijzigingen Opslaan
            </button>
            <a href="<?= url('/dashboard/products') ?>" class="btn btn-secondary" style="flex: 0 0 auto;">
                Annuleren
            </a>
        </div>
    </form>
</div>

<style>
.form-container {
    width: 100%;
    max-width: 100%;
}

.product-form {
    width: 100%;
}

.product-form .card {
    width: 100%;
}

.form-row {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.form-group {
    flex: 1;
    margin-bottom: 0;
}

.form-group label,
.form-label {
    display: block;
    font-weight: 500;
    color: #0f172a;
    margin-bottom: 0.75rem;
    font-size: 0.875rem;
}

.form-control {
    width: 100%;
    padding: 0.625rem 0.875rem;
    font-size: 0.9375rem;
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    transition: border-color 0.2s, box-shadow 0.2s;
}

.form-control:focus {
    outline: none;
    border-color: #0f172a;
    box-shadow: 0 0 0 3px rgba(15, 23, 42, 0.05);
}

/* File input styling */
.file-input {
    padding: 0.5rem;
    cursor: pointer;
    margin-bottom: 1.5rem;
}

.file-input::-webkit-file-upload-button {
    padding: 0.5rem 1rem;
    background: #0f172a;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
    font-weight: 500;
    transition: background 0.2s;
}

.file-input::-webkit-file-upload-button:hover {
    background: #1e293b;
}

/* iOS-style Toggle Switch */
.toggle-container {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 0.75rem 0;
}

.toggle-label {
    font-weight: 500;
    color: #0f172a;
    font-size: 0.9375rem;
}

.toggle-switch {
    position: relative;
    display: inline-block;
    width: 51px;
    height: 31px;
    flex-shrink: 0;
}

.toggle-input {
    opacity: 0;
    width: 0;
    height: 0;
}

.toggle-slider {
    position: absolute;
    cursor: pointer;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: #e2e8f0;
    transition: 0.3s;
    border-radius: 31px;
}

.toggle-slider:before {
    position: absolute;
    content: "";
    height: 27px;
    width: 27px;
    left: 2px;
    bottom: 2px;
    background-color: white;
    transition: 0.3s;
    border-radius: 50%;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
}

.toggle-input:checked + .toggle-slider {
    background-color: #34c759;
}

.toggle-input:focus + .toggle-slider {
    box-shadow: 0 0 0 3px rgba(52, 199, 89, 0.2);
}

.toggle-input:checked + .toggle-slider:before {
    transform: translateX(20px);
}

.form-hint {
    display: block;
    color: #64748b;
    font-size: 0.75rem;
    margin-top: 0.5rem;
}

textarea.form-control {
    resize: vertical;
    min-height: 100px;
}

.card {
    background: white;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    overflow: hidden;
}

.card-header {
    padding: 1rem 1.5rem;
    background: #f8fafc;
    border-bottom: 1px solid #e2e8f0;
}

.card-header h3 {
    font-size: 1rem;
    font-weight: 600;
    color: #0f172a;
    margin: 0;
}

.card-body {
    padding: 1.5rem;
}

.primary-indicator-btn:hover {
    background: #0f172a !important;
    color: white !important;
    border-color: #0f172a !important;
}
.primary-indicator-btn:hover i {
    display: block !important;
}
</style>

<script>
let newImageCounter = 0;

function previewImages(input) {
    console.log('%c📸 previewImages called', 'background: purple; color: white; font-size: 14px; padding: 5px;');
    console.log('Input:', input);
    console.log('Files:', input.files);
    console.log('Number of files:', input.files ? input.files.length : 0);
    
    const imagesGrid = document.querySelector('.images-grid');
    console.log('Images grid found:', imagesGrid);
    
    if (!imagesGrid) {
        console.error('❌ Images grid not found!');
        return;
    }
    
    if (input.files && input.files.length > 0) {
        // Get existing images count ONCE at the start
        const currentExistingImages = imagesGrid.querySelectorAll('[data-image-id]');
        const hasExistingImages = currentExistingImages.length > 0;
        console.log('Existing images:', currentExistingImages.length);
        console.log('Has existing images:', hasExistingImages);
        
        Array.from(input.files).forEach((file, index) => {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                newImageCounter++;
                const tempId = 'new-image-' + newImageCounter;
                console.log('📷 Creating preview for file', index, 'with tempId:', tempId);
                
                const containerDiv = document.createElement('div');
                containerDiv.setAttribute('data-temp-id', tempId);
                containerDiv.setAttribute('data-is-new', 'true');
                containerDiv.style.cssText = 'position: relative; border: 2px solid #e2e8f0; border-radius: 6px; padding: 6px; background: #fff; transition: all 0.3s;';
                containerDiv._fileObject = file;
                
                const imageWrapper = document.createElement('div');
                imageWrapper.className = 'image-wrapper';
                imageWrapper.style.cssText = 'position: relative; width: 100%; height: 140px; border-radius: 4px; overflow: hidden; border: 1px solid #e2e8f0;';
                
                const img = document.createElement('img');
                img.src = e.target.result;
                img.style.cssText = 'width: 100%; height: 100%; object-fit: cover; display: block;';
                img.alt = 'Nieuwe afbeelding ' + newImageCounter;
                
                const primaryIndicator = document.createElement('div');
                primaryIndicator.className = 'primary-indicator-wrapper';
                // FIXED: Removed duplicate existingImages declaration
                primaryIndicator.style.cssText = 'position: absolute; top: 8px; left: 8px; z-index: 10;';
                // Check if there are existing images - if so, new images should not be primary
                const isFirstNewImage = !hasExistingImages && index === 0;
                
                if (isFirstNewImage) {
                    containerDiv.style.border = '2px solid #0f172a';
                    containerDiv.style.background = '#f8fafc';
                    primaryIndicator.innerHTML = '<div class="primary-indicator-active" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;"><i class="fas fa-check" style="font-size: 0.875rem;"></i></div>';
                } else {
                    containerDiv.style.border = '2px solid #e2e8f0';
                    containerDiv.style.background = '#fff';
                    primaryIndicator.innerHTML = '<button type="button" class="primary-indicator-btn" data-temp-id="' + tempId + '" style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent;" title="Maak hoofdfoto"><i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i></button>';
                }
                
                const deleteBtnWrapper = document.createElement('div');
                deleteBtnWrapper.style.cssText = 'position: absolute; top: 8px; right: 8px; z-index: 10;';
                
                const deleteBtn = document.createElement('button');
                deleteBtn.type = 'button';
                deleteBtn.style.cssText = 'width: 36px; height: 36px; border-radius: 50%; background: rgba(220, 38, 38, 0.95); border: 1px solid #dc2626; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: white;';
                deleteBtn.title = 'Verwijderen';
                deleteBtn.innerHTML = '<i class="fas fa-trash" style="font-size: 0.75rem;"></i>';
                deleteBtn.onclick = function() {
                    if (confirm('Weet je zeker dat je deze afbeelding wilt verwijderen?')) {
                        containerDiv.style.transition = 'all 0.3s ease';
                        containerDiv.style.transform = 'scale(0)';
                        containerDiv.style.opacity = '0';
                        setTimeout(() => {
                            containerDiv.remove();
                            removeFileFromInput(input, file);
                            updateAllPrimaryIndicators();
                        }, 300);
                    }
                };
                
                deleteBtnWrapper.appendChild(deleteBtn);
                imageWrapper.appendChild(img);
                imageWrapper.appendChild(primaryIndicator);
                imageWrapper.appendChild(deleteBtnWrapper);
                containerDiv.appendChild(imageWrapper);
                
                // Insert after existing images if they exist, otherwise at the end
                // IMPORTANT: Re-query existing images because reader.onload is async
                const existingAtInsertTime = Array.from(imagesGrid.children).filter(child => 
                    child.hasAttribute('data-image-id')
                );
                
                if (existingAtInsertTime.length > 0) {
                    // Insert after last existing image container (not a button!)
                    const lastExisting = existingAtInsertTime[existingAtInsertTime.length - 1];
                    console.log('📍 Inserting after existing image container:', lastExisting);
                    console.log('Last existing parent:', lastExisting.parentNode);
                    console.log('Images grid:', imagesGrid);
                    console.log('Are they the same?', lastExisting.parentNode === imagesGrid);
                    
                    // Verify that lastExisting is actually in imagesGrid
                    if (lastExisting.parentNode === imagesGrid) {
                        const nextSibling = lastExisting.nextSibling;
                        console.log('Next sibling:', nextSibling);
                        
                        if (nextSibling) {
                            imagesGrid.insertBefore(containerDiv, nextSibling);
                        } else {
                            // No next sibling, so append at the end
                            imagesGrid.appendChild(containerDiv);
                        }
                    } else {
                        console.error('❌ Last existing image is not a child of imagesGrid!');
                        imagesGrid.appendChild(containerDiv);
                    }
                } else {
                    console.log('📍 Appending to grid (no existing images)');
                    imagesGrid.appendChild(containerDiv);
                }
                
                console.log('✅ Container added to grid. Total children:', imagesGrid.children.length);
                console.log('Container element:', containerDiv);
                
                // Update indicators after adding
                updateAllPrimaryIndicators();
            };
            
            console.log('🔄 Starting FileReader for file:', file.name);
            reader.readAsDataURL(file);
        });
    } else {
        console.warn('⚠️ No files selected or input.files is empty');
    }
}

function removeFileFromInput(input, fileToRemove) {
    const dt = new DataTransfer();
    const files = Array.from(input.files);
    files.forEach(file => {
        if (file !== fileToRemove) {
            dt.items.add(file);
        }
    });
    input.files = dt.files;
}

function setPrimaryImage(tempId, input) {
    console.log('%c🎯 setPrimaryImage called', 'background: green; color: white; font-weight: bold;');
    console.log('Temp ID:', tempId);
    console.log('Input:', input);
    
    const imagesGrid = document.querySelector('.images-grid');
    if (!imagesGrid) {
        console.error('❌ Images grid not found!');
        return;
    }
    
    // Update hidden input to tell server which new image should be primary
    // Find the index of this tempId among all NEW images
    const allNewImages = Array.from(imagesGrid.children).filter(child => 
        child.hasAttribute('data-temp-id')
    );
    const targetIndex = allNewImages.findIndex(img => img.getAttribute('data-temp-id') === tempId);
    console.log('📍 New image index for primary:', targetIndex);
    
    if (targetIndex !== -1) {
        const hiddenInput = document.getElementById('new_primary_index');
        if (hiddenInput) {
            hiddenInput.value = targetIndex;
            console.log('✅ Set new_primary_index to:', targetIndex);
        }
    }
    
    // Get all images (both existing and new)
    const allImageContainers = Array.from(imagesGrid.children);
    const targetImage = imagesGrid.querySelector(`[data-temp-id="${tempId}"]`);
    console.log('Target image found:', targetImage);
    console.log('Target image has file object:', targetImage ? !!targetImage._fileObject : false);
    
    if (!targetImage || !targetImage._fileObject) {
        console.error('❌ Target image not found or has no file object!');
        return;
    }
    
    // Reorder files: selected file first
    const selectedFile = targetImage._fileObject;
    const newFiles = [selectedFile];
    
    // Add other new files
    allImageContainers.forEach(container => {
        if (container !== targetImage && container._fileObject) {
            newFiles.push(container._fileObject);
        }
    });
    
    // Update file input
    const dt = new DataTransfer();
    newFiles.forEach(file => dt.items.add(file));
    input.files = dt.files;
    
    // Move target image to first position (but after existing images if they exist)
    // Get existing image CONTAINERS (not buttons inside them)
    const existingImagesInGrid = Array.from(imagesGrid.children).filter(child => 
        child.hasAttribute('data-image-id')
    );
    
    console.log('Existing image containers:', existingImagesInGrid.length);
    
    if (existingImagesInGrid.length > 0) {
        // If there are existing images, insert after the last one
        const lastExisting = existingImagesInGrid[existingImagesInGrid.length - 1];
        console.log('Last existing container:', lastExisting);
        console.log('Last existing parent:', lastExisting.parentNode);
        console.log('Target image parent:', targetImage.parentNode);
        
        // Verify both are in imagesGrid
        if (lastExisting.parentNode === imagesGrid && targetImage.parentNode === imagesGrid) {
            const nextSibling = lastExisting.nextSibling;
            console.log('Next sibling:', nextSibling);
            
            if (nextSibling) {
                imagesGrid.insertBefore(targetImage, nextSibling);
            } else {
                // No next sibling, append at end
                imagesGrid.appendChild(targetImage);
            }
        } else {
            console.error('❌ Elements not in imagesGrid!');
            // Fallback: just append
            imagesGrid.appendChild(targetImage);
        }
    } else {
        // Otherwise, insert at the beginning
        console.log('No existing images, moving to beginning');
        if (targetImage.parentNode === imagesGrid) {
            imagesGrid.insertBefore(targetImage, imagesGrid.firstChild);
        } else {
            imagesGrid.insertBefore(targetImage, imagesGrid.firstChild);
        }
    }
    
    // FIRST: Remove primary from ALL other images (existing and new)
    console.log('🧹 Removing primary from all other images...');
    const allContainers = Array.from(imagesGrid.children);
    allContainers.forEach(container => {
        if (container === targetImage) return; // Skip the target
        
        // Remove primary from existing images
        if (container.hasAttribute('data-image-id')) {
            const indicator = container.querySelector('.primary-indicator');
            if (indicator && indicator.tagName === 'DIV') {
                // This is a primary DIV, replace with button
                const buttonUrl = container.getAttribute('data-set-primary-url');
                const imageId = container.getAttribute('data-image-id');
                
                // Find the image-wrapper
                const imageWrapper = container.querySelector('.image-wrapper');
                if (!imageWrapper) {
                    console.log('No image-wrapper found in setPrimaryImage for image:', imageId);
                    return;
                }
                
                // Find ONLY the LEFT div (primary indicator wrapper)
                const allDivs = Array.from(imageWrapper.children).filter(child => child.tagName === 'DIV');
                const indicatorWrapper = allDivs.find(div => {
                    const style = div.getAttribute('style') || '';
                    const hasLeft = style.includes('left: 8px') || style.includes('left:8px');
                    const hasRight = style.includes('right: 8px') || style.includes('right:8px') || style.includes('right:');
                    return hasLeft && !hasRight;
                });
                
                if (indicatorWrapper) {
                    // Escape quotes in buttonUrl to prevent syntax errors
                    const safeButtonUrl = String(buttonUrl || '').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                    const safeImageId = String(imageId || '').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                    
                    indicatorWrapper.innerHTML = `
                        <button type="button" 
                                class="primary-indicator set-primary-btn"
                                data-url="${safeButtonUrl}"
                                data-image-id="${safeImageId}"
                                style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent; position: relative; z-index: 100;" 
                                title="Maak hoofdfoto" 
                                onmouseover="this.style.background='#0f172a'; this.style.color='white'; this.style.borderColor='#0f172a'; this.querySelector('i').style.display='block';" 
                                onmouseout="this.style.background='rgba(255, 255, 255, 0.95)'; this.style.color='transparent'; this.style.borderColor='#e2e8f0'; this.querySelector('i').style.display='none';">
                            <i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i>
                        </button>
                    `;
                    // Re-attach event listener
                    const newBtn = indicatorWrapper.querySelector('.set-primary-btn');
                    if (newBtn) {
                        newBtn.addEventListener('click', function(e) {
                            e.preventDefault();
                            e.stopPropagation();
                            submitImageAction(this.getAttribute('data-url'), this.getAttribute('data-image-id'), e);
                        });
                    }
                }
                container.style.border = '2px solid #e2e8f0';
                container.style.background = '#fff';
            }
        }
        
        // Remove primary from other new images
        if (container.hasAttribute('data-temp-id') && container !== targetImage) {
            const activeIndicator = container.querySelector('.primary-indicator-active');
            if (activeIndicator) {
                const tempIdAttr = container.getAttribute('data-temp-id');
                const indicatorWrapper = container.querySelector('.primary-indicator-wrapper');
                if (indicatorWrapper && tempIdAttr) {
                    indicatorWrapper.innerHTML = '<button type="button" class="primary-indicator-btn" data-temp-id="' + tempIdAttr + '" style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent;" title="Maak hoofdfoto"><i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i></button>';
                }
                container.style.border = '2px solid #e2e8f0';
                container.style.background = '#fff';
            }
        }
    });
    
    // NOW: Mark this image as primary
    console.log('🎯 Marking target image as primary...');
    targetImage.style.border = '2px solid #0f172a';
    targetImage.style.background = '#f8fafc';
    
    const indicatorWrapper = targetImage.querySelector('.primary-indicator-wrapper');
    if (indicatorWrapper) {
        indicatorWrapper.innerHTML = '<div class="primary-indicator-active" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;"><i class="fas fa-check" style="font-size: 0.875rem;"></i></div>';
        console.log('✅ Primary indicator updated');
    }
    
    console.log('✅ setPrimaryImage completed');
}

function updateAllPrimaryIndicators() {
    const imagesGrid = document.querySelector('.images-grid');
    if (!imagesGrid) return;
    
    const allContainers = Array.from(imagesGrid.children);
    
    // Find first existing image with is_primary, or first NEW image with primary-indicator-active
    // IMPORTANT: Only find ONE primary image
    let primaryIndex = -1;
    let foundPrimary = false;
    
    allContainers.forEach((container, index) => {
        if (foundPrimary) return; // Stop after finding first primary
        
        if (container.hasAttribute('data-image-id')) {
            // This is an existing image from database
            const indicator = container.querySelector('.primary-indicator');
            if (indicator && indicator.tagName === 'DIV') {
                // This is marked as primary
                primaryIndex = index;
                foundPrimary = true;
            }
        } else if (container.hasAttribute('data-temp-id')) {
            // This is a NEW image
            const activeIndicator = container.querySelector('.primary-indicator-active');
            if (activeIndicator) {
                // This new image is marked as primary
                primaryIndex = index;
                foundPrimary = true;
            }
        }
    });
    
    // If no primary found, first image should be primary
    if (primaryIndex === -1 && allContainers.length > 0) {
        primaryIndex = 0;
    }
    
    // ENSURE only ONE image is primary - remove primary from all others
    allContainers.forEach((container, index) => {
        const indicatorWrapper = container.querySelector('.primary-indicator-wrapper');
        if (!indicatorWrapper) return;
        
        const isPrimary = index === primaryIndex;
        
        if (isPrimary) {
            container.style.border = '2px solid #0f172a';
            container.style.background = '#f8fafc';
            
            // Replace button with active indicator if needed (only for new images)
            const btn = indicatorWrapper.querySelector('.primary-indicator-btn');
            if (btn) {
                const tempIdAttr = container.getAttribute('data-temp-id');
                if (tempIdAttr) {
                    indicatorWrapper.innerHTML = '<div class="primary-indicator-active" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;"><i class="fas fa-check" style="font-size: 0.875rem;"></i></div>';
                }
            }
        } else {
            container.style.border = '2px solid #e2e8f0';
            container.style.background = '#fff';
            
            // Replace active indicator with button if needed (only for new images)
            const activeDiv = indicatorWrapper.querySelector('.primary-indicator-active');
            if (activeDiv) {
                const tempIdAttr = container.getAttribute('data-temp-id');
                if (tempIdAttr) {
                    indicatorWrapper.innerHTML = '<button type="button" class="primary-indicator-btn" data-temp-id="' + tempIdAttr + '" style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent;" title="Maak hoofdfoto"><i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i></button>';
                }
            }
        }
    });
}

// DIAGNOSTIC: Test if JavaScript works at all
console.log('%c🔧 JAVASCRIPT LOADED - Product Edit Page', 'background: blue; color: white; font-size: 16px; padding: 10px;');
console.log('Current URL:', window.location.href);
console.log('Time:', new Date().toLocaleString());

// Submit image actions (set primary, delete) via JavaScript
function submitImageAction(url, imageId, event) {
    if (event) {
        event.preventDefault();
        event.stopPropagation();
    }
    
    console.log('submitImageAction called:', url, imageId);
    
    // Get CSRF token - try multiple possible names
    let csrfToken = null;
    const csrfInput = document.querySelector('input[name="csrf_token"]') || 
                      document.querySelector('input[name="_token"]') ||
                      document.querySelector('meta[name="csrf-token"]');
    
    if (csrfInput) {
        csrfToken = csrfInput.value || csrfInput.getAttribute('content');
    }
    
    if (!csrfToken) {
        console.error('CSRF token not found');
        showNotification('Ongeldige aanvraag. Ververs de pagina en probeer het opnieuw.', 'error');
        return;
    }
    
    // Show loading indicator - only disable the button, not the whole container
    const imageContainer = imageId ? document.querySelector(`[data-image-id="${imageId}"]`) : null;
    const clickedButton = (event && event.target) ? event.target.closest('button') : null;
    
    if (clickedButton) {
        clickedButton.style.opacity = '0.5';
        clickedButton.style.pointerEvents = 'none';
        clickedButton.disabled = true;
    } else if (imageContainer) {
        imageContainer.style.opacity = '0.5';
        imageContainer.style.pointerEvents = 'none';
    }
    
    // Send AJAX request
    fetch(url, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: 'csrf_token=' + encodeURIComponent(csrfToken)
    })
    .then(response => {
        console.log('Response status:', response.status);
        if (!response.ok) {
            return response.text().then(text => {
                console.error('Response error:', text);
                throw new Error('Network response was not ok: ' + response.status);
            });
        }
        return response.json();
    })
    .then(data => {
        console.log('Response data:', data);
        if (data.success) {
            // Show success message
            showNotification(data.message, 'success');
            
            // Check if this is a delete action (URL contains 'delete-image')
            if (url.includes('delete-image')) {
                // Remove the image container from DOM
                if (imageContainer) {
                    imageContainer.style.transition = 'all 0.3s ease';
                    imageContainer.style.transform = 'scale(0)';
                    imageContainer.style.opacity = '0';
                    setTimeout(() => {
                        imageContainer.remove();
                        
                        // If there's a new primary image, update the UI
                        if (data.newPrimaryImageId) {
                            updatePrimaryImage(data.newPrimaryImageId);
                        }
                    }, 300);
                }
            } else if (url.includes('set-primary-image')) {
                // Update primary image UI
                console.log('Updating primary image to:', data.imageId);
                // Restore button state first
                if (clickedButton) {
                    clickedButton.style.opacity = '1';
                    clickedButton.style.pointerEvents = 'auto';
                    clickedButton.disabled = false;
                }
                // Update UI
                updatePrimaryImage(data.imageId);
            }
        } else {
            // Show error message
            showNotification(data.message || 'Er is een fout opgetreden.', 'error');
            // Restore button/container state
            if (clickedButton) {
                clickedButton.style.opacity = '1';
                clickedButton.style.pointerEvents = 'auto';
                clickedButton.disabled = false;
            } else if (imageContainer) {
                imageContainer.style.opacity = '1';
                imageContainer.style.pointerEvents = 'auto';
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showNotification('Er is een fout opgetreden. Probeer het opnieuw.', 'error');
        // Restore button/container state
        if (clickedButton) {
            clickedButton.style.opacity = '1';
            clickedButton.style.pointerEvents = 'auto';
            clickedButton.disabled = false;
        } else if (imageContainer) {
            imageContainer.style.opacity = '1';
            imageContainer.style.pointerEvents = 'auto';
        }
    });
}

function updatePrimaryImage(newPrimaryId) {
    console.log('updatePrimaryImage called with ID:', newPrimaryId);
    console.log('Container element:', document.querySelector(`[data-image-id="${newPrimaryId}"]`));
    
    // Remove all primary indicators from all images
    // IMPORTANT: Only get DIV containers with data-image-id, NOT buttons inside them
    const imagesGrid = document.querySelector('.images-grid');
    if (!imagesGrid) {
        console.error('❌ Images grid not found in updatePrimaryImage!');
        return;
    }
    
    const allImageContainers = Array.from(imagesGrid.children).filter(child => 
        child.tagName === 'DIV' && child.hasAttribute('data-image-id')
    );
    console.log('All image containers found:', allImageContainers.length);
    
    allImageContainers.forEach((container, idx) => {
        const imageId = container.getAttribute('data-image-id');
        console.log('Processing container', idx, 'for image:', imageId);
        console.log('Container:', container);
        console.log('Container children:', container.children);
        
        container.style.border = '2px solid #e2e8f0';
        container.style.background = '#fff';
        
        // Find the wrapper div that contains the primary indicator (left side div)
        const imageWrapper = container.querySelector('.image-wrapper');
        console.log('ImageWrapper for', imageId, ':', imageWrapper);
        
        if (!imageWrapper) {
            console.error('❌ No image-wrapper found for image:', imageId, 'Container HTML:', container.outerHTML.substring(0, 200));
            return;
        }
        
        // Find ONLY the LEFT div (primary indicator wrapper)
        // Must have: position: absolute, top: 8px, left: 8px
        // Must NOT have: right: 8px
        const allDivs = Array.from(imageWrapper.children).filter(child => child.tagName === 'DIV');
        const indicatorWrapper = allDivs.find(div => {
            const style = div.getAttribute('style') || '';
            const hasLeft = style.includes('left: 8px') || style.includes('left:8px');
            const hasRight = style.includes('right: 8px') || style.includes('right:8px') || style.includes('right:');
            return hasLeft && !hasRight;
        });
        
        console.log('All divs in image-wrapper:', allDivs.length);
        console.log('Indicator wrapper found:', !!indicatorWrapper);
        
        if (!indicatorWrapper) {
            console.log('No indicator wrapper found for image:', imageId);
            return;
        }
        
        // Find the primary indicator inside the wrapper
        const primaryIndicator = indicatorWrapper.querySelector('.primary-indicator');
        if (primaryIndicator) {
            const buttonUrl = container.getAttribute('data-set-primary-url');
            console.log('Found primary indicator, type:', primaryIndicator.tagName, 'for image:', imageId);
            
            // Replace the DIV with a BUTTON (for non-primary images)
            if (primaryIndicator.tagName === 'DIV') {
                // Escape quotes in buttonUrl to prevent syntax errors
                const safeButtonUrl = String(buttonUrl || '').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                const safeImageId = String(imageId || '').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                
                indicatorWrapper.innerHTML = `
                    <button type="button" 
                            class="primary-indicator set-primary-btn"
                            data-url="${safeButtonUrl}"
                            data-image-id="${safeImageId}"
                            style="width: 36px; height: 36px; border-radius: 50%; background: rgba(255, 255, 255, 0.95); border: 1px solid #e2e8f0; display: flex; align-items: center; justify-content: center; cursor: pointer; box-shadow: 0 2px 8px rgba(0,0,0,0.15); transition: all 0.2s; color: transparent; position: relative; z-index: 20;" 
                            title="Maak hoofdfoto" 
                            onmouseover="this.style.background='#0f172a'; this.style.color='white'; this.style.borderColor='#0f172a'; this.querySelector('i').style.display='block';" 
                            onmouseout="this.style.background='rgba(255, 255, 255, 0.95)'; this.style.color='transparent'; this.style.borderColor='#e2e8f0'; this.querySelector('i').style.display='none';">
                        <i class="fas fa-check" style="font-size: 0.875rem; display: none;"></i>
                    </button>
                `;
                
                // Re-attach event listener to the newly created button
                const newButton = indicatorWrapper.querySelector('.set-primary-btn');
                if (newButton) {
                    newButton.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopPropagation();
                        const url = this.getAttribute('data-url');
                        const imgId = this.getAttribute('data-image-id');
                        console.log('Dynamically created button clicked:', url, imgId);
                        submitImageAction(url, imgId, e);
                    });
                }
            }
        }
    });
    
    // Add primary indicator to new primary image
    const newPrimaryContainer = document.querySelector(`[data-image-id="${newPrimaryId}"]`);
    if (newPrimaryContainer) {
        console.log('Found new primary container:', newPrimaryId);
        newPrimaryContainer.style.border = '2px solid #0f172a';
        newPrimaryContainer.style.background = '#f8fafc';
        newPrimaryContainer.style.opacity = '1';
        newPrimaryContainer.style.pointerEvents = 'auto';
        
        // Find the indicator wrapper
        const imageWrapper = newPrimaryContainer.querySelector('.image-wrapper');
        if (imageWrapper) {
            // Find ONLY the LEFT div (primary indicator wrapper)
            const allDivs = Array.from(imageWrapper.children).filter(child => child.tagName === 'DIV');
            const indicatorWrapper = allDivs.find(div => {
                const style = div.getAttribute('style') || '';
                const hasLeft = style.includes('left: 8px') || style.includes('left:8px');
                const hasRight = style.includes('right: 8px') || style.includes('right:8px') || style.includes('right:');
                return hasLeft && !hasRight;
            });
            
            if (indicatorWrapper) {
                // Replace button with primary indicator (div)
                const primaryIndicator = indicatorWrapper.querySelector('.primary-indicator');
                if (primaryIndicator && primaryIndicator.tagName === 'BUTTON') {
                    console.log('Replacing button with div for new primary');
                    indicatorWrapper.innerHTML = `
                        <div class="primary-indicator" style="width: 36px; height: 36px; border-radius: 50%; background: #0f172a; border: 1px solid #0f172a; display: flex; align-items: center; justify-content: center; box-shadow: 0 2px 8px rgba(0,0,0,0.2); color: white;">
                            <i class="fas fa-check" style="font-size: 0.875rem;"></i>
                        </div>
                    `;
                }
            } else {
                console.log('No indicator wrapper found for new primary');
            }
        }
    } else {
        console.log('New primary container not found:', newPrimaryId);
    }
}

function showNotification(message, type = 'success') {
    // Sanitize message to prevent syntax errors
    const safeMessage = String(message || '').replace(/`/g, '\\`').replace(/\${/g, '\\${');
    
    // Create notification element
    const notification = document.createElement('div');
    const bgColor = type === 'success' ? '#0f172a' : '#dc2626';
    notification.style.cssText = `
        position: fixed;
        top: 20px;
        right: 20px;
        background: ${bgColor};
        color: white;
        padding: 1rem 1.5rem;
        border-radius: 6px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        z-index: 10000;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        animation: slideIn 0.3s ease;
        max-width: 400px;
    `;
    
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-circle';
    notification.innerHTML = `
        <i class="fas ${icon}" style="font-size: 1.25rem;"></i>
        <span style="font-size: 0.9rem;">${safeMessage}</span>
    `;
    
    document.body.appendChild(notification);
    
    // Remove after 3 seconds
    setTimeout(() => {
        notification.style.transition = 'opacity 0.3s ease';
        notification.style.opacity = '0';
        setTimeout(() => {
            notification.remove();
        }, 300);
    }, 3000);
}

// updatePrimaryIndicators is now replaced by updateAllPrimaryIndicators

// Event delegation for primary indicator buttons (for NEW images)
document.addEventListener('click', function(e) {
    const btn = e.target.closest('.primary-indicator-btn');
    if (btn) {
        console.log('%c🖼️ Primary indicator button clicked (NEW image)', 'background: blue; color: white; font-weight: bold;');
        e.preventDefault();
        e.stopPropagation();
        const tempId = btn.getAttribute('data-temp-id');
        console.log('Temp ID:', tempId);
        const input = document.getElementById('images');
        console.log('Input found:', input);
        
        if (tempId && input) {
            console.log('Calling setPrimaryImage...');
            setPrimaryImage(tempId, input);
        } else {
            console.error('❌ Missing tempId or input!', {tempId, input});
        }
    }
}, true);

// Initialize indicators on page load
document.addEventListener('DOMContentLoaded', function() {
    console.log('%c=== PAGE LOADED - PRODUCT EDIT ===', 'background: #222; color: #bada55; font-size: 14px; padding: 5px;');
    console.log('Set-primary buttons found:', document.querySelectorAll('.set-primary-btn').length);
    console.log('Delete buttons found:', document.querySelectorAll('.delete-image-btn').length);
    
    updateAllPrimaryIndicators();
    
    // Add event listeners to EXISTING set-primary buttons
    const setPrimaryButtons = document.querySelectorAll('.set-primary-btn');
    console.log('%cAttaching listeners to ' + String(setPrimaryButtons.length) + ' set-primary buttons', 'color: blue; font-weight: bold;');
    
    setPrimaryButtons.forEach((button, index) => {
        const url = button.getAttribute('data-url');
        const imageId = button.getAttribute('data-image-id');
        console.log('  Button ' + index + ': url=' + url + ', imageId=' + imageId);
        
        button.addEventListener('click', function(e) {
            console.log('%c=== SET PRIMARY BUTTON CLICKED (index: ' + String(index) + ') ===', 'background: green; color: white; font-size: 12px; padding: 3px;');
            console.log('Event:', e);
            console.log('This:', this);
            console.log('URL:', url);
            console.log('ImageID:', imageId);
            
            e.preventDefault();
            e.stopPropagation();
            
            submitImageAction(url, imageId, e);
        });
    });
    
    // Add event listeners to EXISTING delete buttons
    const deleteButtons = document.querySelectorAll('.delete-image-btn');
    console.log('%cAttaching listeners to ' + String(deleteButtons.length) + ' delete buttons', 'color: red; font-weight: bold;');
    
    deleteButtons.forEach((button, index) => {
        const url = button.getAttribute('data-url');
        const imageId = button.getAttribute('data-image-id');
        console.log('  Delete button ' + String(index) + ': url=' + String(url) + ', imageId=' + String(imageId));
        
        button.addEventListener('click', function(e) {
            console.log('%c=== DELETE BUTTON CLICKED (index: ' + String(index) + ') ===', 'background: red; color: white; font-size: 12px; padding: 3px;');
            console.log('Event:', e);
            console.log('This:', this);
            console.log('URL:', url);
            console.log('ImageID:', imageId);
            
            e.preventDefault();
            e.stopPropagation();
            
            if (confirm('Weet je zeker dat je deze afbeelding wilt verwijderen?')) {
                submitImageAction(url, imageId, e);
            } else {
                console.log('Delete cancelled by user');
            }
        });
    });
    
    console.log('%c=== INITIALIZATION COMPLETE ===', 'background: #222; color: #bada55; font-size: 14px; padding: 5px;');
    
    // FALLBACK: Also use event delegation on document.body
    console.log('Setting up fallback event delegation...');
    document.body.addEventListener('click', function(e) {
        // Check if clicked element is a set-primary button
        const setPrimaryBtn = e.target.closest('.set-primary-btn');
        if (setPrimaryBtn) {
            console.log('%c🎯 FALLBACK: Set primary button clicked!', 'background: orange; color: black; font-weight: bold;');
            e.preventDefault();
            e.stopPropagation();
            const url = setPrimaryBtn.getAttribute('data-url');
            const imageId = setPrimaryBtn.getAttribute('data-image-id');
            console.log('URL:', url, 'ImageID:', imageId);
            submitImageAction(url, imageId, e);
            return;
        }
        
        // Check if clicked element is a delete button
        const deleteBtn = e.target.closest('.delete-image-btn');
        if (deleteBtn) {
            console.log('%c🎯 FALLBACK: Delete button clicked!', 'background: red; color: white; font-weight: bold;');
            e.preventDefault();
            e.stopPropagation();
            const url = deleteBtn.getAttribute('data-url');
            const imageId = deleteBtn.getAttribute('data-image-id');
            console.log('URL:', url, 'ImageID:', imageId);
            if (confirm('Weet je zeker dat je deze afbeelding wilt verwijderen?')) {
                submitImageAction(url, imageId, e);
            }
            return;
        }
    }, true); // Use capture phase
});

document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('.product-form');
    if (form) {
        form.addEventListener('submit', function(e) {
            if (window.quill) {
                const descriptionTextarea = document.getElementById('description');
                if (descriptionTextarea) {
                    descriptionTextarea.value = window.quill.root.innerHTML;
                }
            }
        });
    }
});
</script>

<!-- Quill Rich Text Editor -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const editorContainer = document.getElementById('description-editor');
    const descriptionTextarea = document.getElementById('description');
    
    if (editorContainer && descriptionTextarea) {
        window.quill = new Quill('#description-editor', {
            theme: 'snow',
            modules: {
                toolbar: [
                    [{ 'header': [1, 2, 3, false] }],
                    ['bold', 'italic', 'underline', 'strike'],
                    ['link'],
                    [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                    [{ 'color': [] }, { 'background': [] }],
                    ['clean']
                ]
            },
            placeholder: 'Voeg een productbeschrijving toe...'
        });
        
        const initialContent = descriptionTextarea.value;
        if (initialContent) {
            window.quill.root.innerHTML = initialContent;
        }
        
        window.quill.on('text-change', function() {
            descriptionTextarea.value = window.quill.root.innerHTML;
        });
        
        const style = document.createElement('style');
        style.textContent = `
            .ql-container {
                font-family: 'Inter', sans-serif;
                font-size: 0.9375rem;
                border-bottom-left-radius: 6px;
                border-bottom-right-radius: 6px;
            }
            .ql-toolbar {
                border-top-left-radius: 6px;
                border-top-right-radius: 6px;
                border: 1px solid #e2e8f0;
                border-bottom: none;
                background: #f8fafc;
            }
            .ql-container {
                border: 1px solid #e2e8f0;
                border-top: none;
            }
            .ql-editor {
                min-height: 200px;
                padding: 1rem;
            }
            .ql-editor.ql-blank::before {
                color: #94a3b8;
                font-style: normal;
            }
            .ql-snow .ql-stroke {
                stroke: #64748b;
            }
            .ql-snow .ql-fill {
                fill: #64748b;
            }
            .ql-snow .ql-picker-label:hover .ql-stroke,
            .ql-snow .ql-picker-label.ql-active .ql-stroke {
                stroke: #0f172a;
            }
            .ql-snow .ql-picker-label:hover .ql-fill,
            .ql-snow .ql-picker-label.ql-active .ql-fill {
                fill: #0f172a;
            }
            .ql-snow button:hover,
            .ql-snow button.ql-active {
                color: #0f172a;
            }
        `;
        document.head.appendChild(style);
    }
});
</script>
