# Database Setup Instructies

## Database naam: `oraviare`

## Methode 1: Via phpMyAdmin (Aanbevolen)

1. Open phpMyAdmin in je browser (meestal: `http://localhost/phpmyadmin`)
2. Klik op "Import" in het menu
3. Selecteer het bestand: `database/vps2_schema.sql`
4. Klik op "Go" om te importeren
5. De database `oraviare` wordt automatisch aangemaakt met alle tabellen en demo data

## Methode 2: Via Command Line (als MySQL client geïnstalleerd is)

```bash
# Als MySQL draait, voer uit:
mysql -u root -p < Admin/database/vps2_schema.sql

# Of zonder wachtwoord:
mysql -u root < Admin/database/vps2_schema.sql
```

## Methode 3: Via PHP Setup Script

```bash
# Zorg eerst dat MySQL/MariaDB draait
sudo systemctl start mysql
# of
sudo systemctl start mariadb

# Voer dan het setup script uit:
cd Admin
php setup_database.php
```

## Database Configuratie

De database configuratie staat in: `Admin/config/database.php`

```php
'database' => 'oraviare',
'username' => 'root',
'password' => '', // Pas aan indien nodig
```

## Tabellen

Na import bevat de database de volgende tabellen:

- `furniture_orders` - Orders van VPS1
- `furniture_products` - Furniture producten
- `furniture_categories` - Product categorieën
- `furniture_product_images` - Product afbeeldingen
- `api_credentials` - API keys voor VPS1 authenticatie
- `api_access_log` - Logging van API calls
- `users` - Admin gebruikers

## Demo Data

Het schema bevat demo data:
- 7 categorieën (Stoelen, Tafels, Lampen, etc.)
- 5 voorbeeld producten
- 1 admin gebruiker (username: `admin`, wachtwoord: `admin123`)
- 1 placeholder API credential

## Troubleshooting

**MySQL draait niet:**
```bash
sudo systemctl start mysql
# of
sudo systemctl start mariadb
```

**Toegang geweigerd:**
- Controleer of MySQL/MariaDB draait
- Controleer gebruikersnaam en wachtwoord in `config/database.php`
- Controleer of de MySQL service luistert op localhost:3306
