-- =============================================
-- MIGRATION: Voeg furniture_categories tabel toe
-- =============================================
-- Uitvoeren: Voeg categories tabel toe voor product categorieën

CREATE TABLE IF NOT EXISTS `furniture_categories` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL UNIQUE,
    `slug` VARCHAR(100) NOT NULL UNIQUE,
    `description` TEXT NULL,
    `sort_order` INT DEFAULT 0,
    `status` ENUM('active', 'inactive') DEFAULT 'active',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `uk_name` (`name`),
    UNIQUE KEY `uk_slug` (`slug`),
    INDEX `idx_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Demo categorieën toevoegen
INSERT INTO `furniture_categories` (`name`, `slug`, `description`, `sort_order`, `status`) VALUES
('Stoelen', 'stoelen', 'Alle stoelen en zitmeubelen', 1, 'active'),
('Tafels', 'tafels', 'Tafels voor elke ruimte', 2, 'active'),
('Lampen', 'lampen', 'Verlichting en lampen', 3, 'active'),
('Kussens', 'kussens', 'Decoratieve kussens', 4, 'active'),
('Vazen', 'vazen', 'Decoratieve vazen', 5, 'active'),
('Decoratie', 'decoratie', 'Algemene decoratie', 6, 'active'),
('Accessoires', 'accessoires', 'Meubel accessoires', 7, 'active');
