-- =============================================
-- MIGRATION: Voeg furniture_product_images tabel toe
-- =============================================
-- Uitvoeren: Voeg tabel toe voor meerdere afbeeldingen per product

CREATE TABLE IF NOT EXISTS `furniture_product_images` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `product_id` INT UNSIGNED NOT NULL COMMENT 'Foreign key naar furniture_products.id',
    `image_path` VARCHAR(255) NOT NULL COMMENT 'Pad naar afbeelding',
    `is_primary` BOOLEAN DEFAULT 0 COMMENT 'Is dit de hoofdfoto?',
    `sort_order` INT DEFAULT 0 COMMENT 'Sorteervolgorde',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    INDEX `idx_product` (`product_id`),
    INDEX `idx_primary` (`is_primary`),
    INDEX `idx_sort` (`sort_order`),
    CONSTRAINT `fk_product_images_product` FOREIGN KEY (`product_id`) REFERENCES `furniture_products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Migreer bestaande image_url naar furniture_product_images
INSERT INTO `furniture_product_images` (`product_id`, `image_path`, `is_primary`, `sort_order`)
SELECT `id`, `image_url`, 1, 0
FROM `furniture_products`
WHERE `image_url` IS NOT NULL AND `image_url` != '';
