<?php
/**
 * VPS2 Furniture Shop - Web Routes
 * API endpoints voor VPS1 order processing
 */

use App\Controllers\OrderApiController;
use App\Controllers\OrderController;
use App\Controllers\AuthController;
use App\Controllers\DashboardController;
use App\Controllers\ProductApiController;
use App\Controllers\ProductController;
use App\Controllers\CategoryController;
use App\Controllers\CheckoutController;

// ===== PUBLIC ROUTES =====

// Home / Login
$router->get('/', [AuthController::class, 'loginForm']);
$router->get('/login', [AuthController::class, 'loginForm']);
$router->post('/login', [AuthController::class, 'login']);
$router->get('/logout', [AuthController::class, 'logout']);

// ===== DASHBOARD ROUTES (vereisen ingelogde gebruiker) =====

// Dashboard home
$router->get('/dashboard', [DashboardController::class, 'index']);

// Orders beheer
$router->get('/dashboard/orders', [DashboardController::class, 'orders']);
$router->get('/dashboard/orders/view/{id}', [DashboardController::class, 'viewOrder']);

// Producten beheer
$router->get('/dashboard/products', [ProductController::class, 'index']);
$router->get('/dashboard/products/create', [ProductController::class, 'create']);
$router->post('/dashboard/products/create', [ProductController::class, 'store']);
$router->get('/dashboard/products/edit/{id}', [ProductController::class, 'edit']);
$router->post('/dashboard/products/edit/{id}', [ProductController::class, 'update']);
$router->post('/dashboard/products/delete/{id}', [ProductController::class, 'delete']);
$router->post('/dashboard/products/set-primary-image/{id}', [ProductController::class, 'setPrimaryImage']);
$router->post('/dashboard/products/delete-image/{id}', [ProductController::class, 'deleteImage']);

// Categorieën beheer
$router->get('/dashboard/categories', [CategoryController::class, 'index']);
$router->get('/dashboard/categories/create', [CategoryController::class, 'create']);
$router->post('/dashboard/categories/create', [CategoryController::class, 'store']);
$router->get('/dashboard/categories/edit/{slug}', [CategoryController::class, 'edit']);
$router->post('/dashboard/categories/edit/{slug}', [CategoryController::class, 'update']);
$router->post('/dashboard/categories/delete/{slug}', [CategoryController::class, 'delete']);

// Instellingen
$router->get('/dashboard/settings', [DashboardController::class, 'settings']);
$router->post('/dashboard/settings', [DashboardController::class, 'updateSettings']);
$router->post('/dashboard/settings/generate-credentials', [DashboardController::class, 'generateCredentials']);
$router->get('/dashboard/settings/check-connection', [DashboardController::class, 'checkConnection']);

// ===== API INFO ROUTE =====
$router->get('/api', function() {
    header('Content-Type: application/json');
    echo json_encode([
        'success' => true,
        'message' => 'VPS2 Furniture Shop API',
        'version' => '1.0',
        'endpoints' => [
            'POST /api/v1/orders/create' => 'Create new furniture order',
            'GET /api/v1/orders/{id}/status' => 'Get order payment status',
            'GET /api/v1/orders' => 'List all orders (monitoring)',
            'GET /api/v1/orders/{id}' => 'Get order details',
            'POST /api/v1/orders/{id}/webhook' => 'Manually send webhook to VPS1',
            'POST /api/v1/webhooks/process' => 'Process all pending webhooks'
        ]
    ]);
});

// ===== PUBLIC CHECKOUT ROUTES =====

// Checkout (publiek, geen login vereist)
$router->get('/checkout/{id}', [CheckoutController::class, 'show']);
$router->post('/checkout/{id}/pay', [CheckoutController::class, 'pay']);
$router->get('/checkout/{id}/success', [CheckoutController::class, 'success']);

// ===== PUBLIC API ROUTES (voor VPS1) =====

// API v1 - Order Management
$router->post('/api/v1/orders/create', [OrderApiController::class, 'createOrder']);
$router->get('/api/v1/orders/{id}/status', [OrderApiController::class, 'getOrderStatus']);
$router->post('/api/v1/orders/{id}/payment-status', [OrderApiController::class, 'updatePaymentStatus']);

// API v1 - Product Management (voor VPS1)
$router->get('/api/v1/products', [ProductApiController::class, 'index']);
$router->get('/api/v1/products/{id}', [ProductApiController::class, 'show']);

// ===== MONITORING ROUTES (voor VPS2 admin) =====
$router->get('/api/v1/orders', [OrderController::class, 'index']);
$router->get('/api/v1/orders/{id}', [OrderController::class, 'show']);
$router->post('/api/v1/orders/{id}/webhook', [OrderController::class, 'sendWebhook']);
$router->post('/api/v1/webhooks/process', [OrderController::class, 'processPendingWebhooks']);

