# Adalyapoint & Obevaria Monorepo

Deze repository bevat beide codebases:
- **Oraviare/** - VPS2 (Furniture Shop / Payment Processing) - Obevaria
- **AdalyaPoint/** - VPS1 (Vape Webshop / Main Shop) - Adalyapoint

## Structuur

```
/
├── Oraviare/              # VPS2 codebase (Obevaria)
│   └── Admin/
├── AdalyaPoint/           # VPS1 codebase (Adalyapoint)
│   └── Admin/
└── .gitignore            # Exclude VPS-specifieke configs
```

## Belangrijk

- **Configuratie bestanden worden NIET gecommit** (database.php, app.php)
- Elke VPS heeft zijn eigen configuratie
- Code wijzigingen worden gedeeld via Git

## Workflow

1. **Wijzigingen maken in één VPS:**
   ```bash
   git add .
   git commit -m "Beschrijving van wijziging"
   git push
   ```

2. **Wijzigingen ophalen op andere VPS:**
   ```bash
   git pull
   ```

3. **Configuratie aanpassen (lokaal, niet committen):**
   - Pas `config/database.php` aan (VPS-specifiek)
   - Pas `config/app.php` aan (VPS-specifiek)

## Setup op VPS1 (Adalyapoint)

1. Clone deze repo naar `/var/www/html/`
2. De code staat in `AdalyaPoint/Admin/`
3. Kopieer configuratie bestanden (als nodig):
   ```bash
   cp AdalyaPoint/Admin/config/database.php.example AdalyaPoint/Admin/config/database.php
   cp AdalyaPoint/Admin/config/app.php.example AdalyaPoint/Admin/config/app.php
   ```
4. Pas configuratie aan voor VPS1

## Setup op VPS2 (Obevaria)

1. Clone deze repo naar `/var/www/html/`
2. De code staat in `Oraviare/Admin/`
3. Kopieer configuratie bestanden (als nodig):
   ```bash
   cp Oraviare/Admin/config/database.php.example Oraviare/Admin/config/database.php
   cp Oraviare/Admin/config/app.php.example Oraviare/Admin/config/app.php
   ```
4. Pas configuratie aan voor VPS2
