# Monorepo Setup Instructies

## Huidige Status

✅ **VPS2 (Obevaria)**: Code staat in `/var/www/html/obevaria/`
- Git repo geïnitialiseerd
- Eerste commit gemaakt

⏳ **VPS1 (Adalyapoint)**: Moet nog worden toegevoegd

## Belangrijk: Directory naam wijziging

De directory is hernoemd van `Oraviare` naar `obevaria`. 

**⚠️ Controleer of je webserver configuratie nog werkt!**

Als je Apache/Nginx configuratie nog naar `/var/www/html/Oraviare` verwijst, moet je deze aanpassen naar `/var/www/html/obevaria`.

## Stap 1: Webserver configuratie aanpassen (VPS2)

Controleer je Apache/Nginx configuratie:

```bash
# Apache
grep -r "Oraviare" /etc/apache2/
# Of
grep -r "Oraviare" /etc/httpd/

# Nginx  
grep -r "Oraviare" /etc/nginx/
```

Pas alle verwijzingen aan van `Oraviare` naar `obevaria`.

## Stap 2: VPS1 (Adalyapoint) toevoegen aan monorepo

### Optie A: Via Git (aanbevolen)

1. **Op VPS1**, clone deze repo:
   ```bash
   cd /var/www/html
   git clone <repository-url> .
   # Of als je al een repo hebt:
   git remote add origin <repository-url>
   git pull origin master
   ```

2. **Verplaats Adalyapoint code naar monorepo structuur:**
   ```bash
   # Als Adalyapoint nu in /var/www/html/AdalyaPoint/ staat:
   mv AdalyaPoint adalyapoint
   ```

3. **Voeg toe aan Git:**
   ```bash
   git add adalyapoint/
   git commit -m "Add Adalyapoint (VPS1) codebase"
   git push
   ```

### Optie B: Handmatig kopiëren

1. **Op VPS2**, maak een placeholder:
   ```bash
   mkdir -p /var/www/html/adyalapoint
   echo "# Adalyapoint codebase komt hier" > /var/www/html/adyalapoint/README.md
   git add adalyapoint/
   git commit -m "Add placeholder for Adalyapoint"
   ```

2. **Op VPS1**, kopieer code:
   ```bash
   # Kopieer Adalyapoint code naar adalyapoint directory
   cp -r /var/www/html/AdalyaPoint/* /var/www/html/adyalapoint/
   ```

3. **Commit op VPS1:**
   ```bash
   cd /var/www/html
   git add adalyapoint/
   git commit -m "Add Adalyapoint (VPS1) codebase"
   git push
   ```

## Stap 3: Configuratie bestanden

Beide VPS'en hebben hun eigen configuratie:

- `obevaria/Admin/config/database.php` - VPS2 database config
- `obevaria/Admin/config/app.php` - VPS2 app config
- `adyalapoint/Admin/config/database.php` - VPS1 database config  
- `adyalapoint/Admin/config/app.php` - VPS1 app config

**Deze worden NIET gecommit** (staan in .gitignore)

## Stap 4: Workflow voor wijzigingen

### Wijziging maken op VPS2:
```bash
cd /var/www/html
# Maak wijzigingen
git add .
git commit -m "Fix: beschrijving"
git push
```

### Wijziging ophalen op VPS1:
```bash
cd /var/www/html
git pull
```

## Troubleshooting

**Probleem: Website werkt niet na directory rename**
- Controleer webserver configuratie
- Controleer .htaccess bestanden
- Check Apache/Nginx error logs

**Probleem: Git pull faalt op VPS1**
- Zorg dat beide VPS'en toegang hebben tot dezelfde Git repo
- Of gebruik een remote repository (GitHub, GitLab, etc.)
