# Instructies voor VPS1 (Adalyapoint) - Monorepo Setup

## 🎯 Wat is er gebeurd?

Op **VPS2 (Obevaria)** is een monorepo opgezet. Dit betekent dat beide VPS'en nu één Git repository delen, zodat code wijzigingen makkelijk gesynchroniseerd kunnen worden.

## 📋 Wat moet je doen op VPS1?

### ⚠️ BELANGRIJK: Vraag eerst aan VPS2!

**Voordat je begint, vraag aan VPS2:**
1. Is er een remote repository (GitHub/GitLab)? → Geef de URL
2. Of moet ik de backup methode gebruiken? → VPS2 maakt dan een tar.gz bestand

### Stap 1: Controleer of Git geïnstalleerd is

```bash
git --version
```

Als Git niet geïnstalleerd is:
```bash
sudo apt update
sudo apt install git -y
```

### Stap 2: Kies een methode om de monorepo te krijgen

Je hebt **twee opties**:

---

## 🔀 Optie A: Via Remote Repository (Aanbevolen)

**Als VPS2 een remote repository heeft ingesteld (GitHub/GitLab):**

### 2.1. Vraag de repository URL aan VPS2

**Op VPS2**, check of er een remote is ingesteld:
```bash
cd /var/www/html
git remote -v
```

Als er een remote is (bijv. GitHub/GitLab), noteer de URL.

**Als er GEEN remote is**, moet VPS2 eerst een remote repository aanmaken:
- Maak een repository aan op GitHub/GitLab/Bitbucket
- Voeg toe op VPS2:
  ```bash
  cd /var/www/html
  git remote add origin <repository-url>
  git push -u origin master
  ```

### 2.2. Clone de repository op VPS1

**Op VPS1**, gebruik de URL die je van VPS2 hebt gekregen:

```bash
cd /var/www/html

# Als je nog GEEN code hebt:
git clone <repository-url> .

# Als je WEL al code hebt (AdalyaPoint bestaat al):
# Stap 1: Maak backup van je bestaande code
cp -r AdalyaPoint AdalyaPoint.backup

# Stap 2: Initialiseer Git
git init

# Stap 3: Voeg remote toe
git remote add origin <repository-url>

# Stap 4: Haal monorepo op
git pull origin master --allow-unrelated-histories

# Stap 5: Herstel je AdalyaPoint code (als die overschreven is)
# (Alleen als nodig - check eerst of AdalyaPoint/ al bestaat)
```

### 2.2. Verplaats je bestaande Adalyapoint code

**BELANGRIJK**: Als je Adalyapoint code al in `/var/www/html/AdalyaPoint/` staat:

```bash
# Check eerst of AdalyaPoint al bestaat
ls -la /var/www/html/AdalyaPoint/

# Als het al bestaat en de juiste naam heeft, hoef je niets te doen!
# Als het een andere naam heeft, hernoem het:
# mv /var/www/html/<oude-naam> /var/www/html/AdalyaPoint
```

### 2.3. Voeg Adalyapoint toe aan Git

```bash
cd /var/www/html
git add AdalyaPoint/
git commit -m "Add Adalyapoint (VPS1) codebase"
git push
```

---

## 🔀 Optie B: Direct van VPS2 (Zonder Remote)

**Als er nog geen remote repository is:**

### 2.1. Maak SSH verbinding mogelijk (optioneel)

Als je SSH toegang hebt tussen VPS'en, kun je direct pushen/pullen.

### 2.2. Handmatig kopiëren

**Op VPS2**, exporteer de Git repo:
```bash
cd /var/www/html
tar -czf monorepo-backup.tar.gz .git Oraviare/ README.md SETUP.md MONOREPO_UITLEG.md .gitignore
```

**Op VPS1**, importeer:
```bash
# Upload monorepo-backup.tar.gz naar VPS1
cd /var/www/html
tar -xzf monorepo-backup.tar.gz

# Initialiseer Git
git init
git remote add origin <vps2-ip-of-url>
```

### 2.3. Verplaats Adalyapoint code

```bash
# Als AdalyaPoint al bestaat op de juiste plek, voeg toe:
cd /var/www/html
git add AdalyaPoint/
git commit -m "Add Adalyapoint (VPS1) codebase"
```

---

## ⚠️ BELANGRIJK: Configuratie Bestanden

**Deze bestanden worden NIET gecommit** (staan in `.gitignore`):

- `AdalyaPoint/Admin/config/database.php` ❌
- `AdalyaPoint/Admin/config/app.php` ❌

**Zorg dat deze bestanden bestaan en correct zijn ingesteld voor VPS1!**

Als ze niet bestaan:
```bash
# Maak ze aan met je VPS1-specifieke instellingen
nano AdalyaPoint/Admin/config/database.php
nano AdalyaPoint/Admin/config/app.php
```

---

## ✅ Test of het werkt

### Test 1: Git status

```bash
cd /var/www/html
git status
```

Je zou moeten zien:
- `Oraviare/` (van VPS2)
- `AdalyaPoint/` (jouw code)
- Geen wijzigingen in `config/` bestanden (die worden genegeerd)

### Test 2: Test synchronisatie

**Op VPS2**, maak een test wijziging:
```bash
echo "# Test sync" >> README.md
git add README.md
git commit -m "Test: synchronisatie"
git push
```

**Op VPS1**, haal de wijziging op:
```bash
cd /var/www/html
git pull
```

Als dit werkt, zie je de wijziging in `README.md`! ✅

---

## 📁 Verwachte Structuur na Setup

```
/var/www/html/
├── .git/                    (Git repository)
├── .gitignore              (Exclude configs)
├── README.md                (Documentatie)
├── SETUP.md                 (Setup instructies)
├── MONOREPO_UITLEG.md      (Uitleg document)
│
├── Oraviare/                (VPS2 - Obevaria)
│   └── Admin/
│       ├── config/
│       │   ├── database.php  ❌ NIET in Git
│       │   └── app.php       ❌ NIET in Git
│       └── ...
│
└── AdalyaPoint/             (VPS1 - Adalyapoint) ✅ JOUW CODE
    └── Admin/
        ├── config/
        │   ├── database.php  ❌ NIET in Git (lokaal!)
        │   └── app.php       ❌ NIET in Git (lokaal!)
        └── ...
```

---

## 🔄 Workflow na Setup

### Wijziging maken op VPS1:

```bash
cd /var/www/html
# Maak wijzigingen in AdalyaPoint/
git add AdalyaPoint/
git commit -m "Beschrijving van wijziging"
git push
```

### Wijziging ophalen van VPS2:

```bash
cd /var/www/html
git pull
# Wijzigingen van VPS2 zijn nu ook op VPS1! ✅
```

---

## ❓ Veelgestelde Vragen

**V: Wat als mijn AdalyaPoint code een andere naam heeft?**
A: Hernoem de directory naar `AdalyaPoint` voordat je het toevoegt aan Git.

**V: Wat als ik per ongeluk config bestanden commit?**
A: Ze staan in `.gitignore`, dus Git negeert ze automatisch. Als je ze toch commit, verwijder ze uit Git geschiedenis.

**V: Moet ik mijn bestaande code verwijderen?**
A: Nee! Verplaats het alleen naar de juiste locatie (`AdalyaPoint/`) en voeg het toe aan Git.

**V: Wat als de website niet meer werkt na setup?**
A: Controleer:
- Webserver configuratie (Apache/Nginx)
- Of de directory naam correct is
- Of config bestanden bestaan en correct zijn

**V: Kan ik alleen mijn eigen code (AdalyaPoint) updaten?**
A: Ja! Commit alleen `AdalyaPoint/` directory. VPS2 krijgt alleen updates als ze `git pull` doen.

---

## 🆘 Problemen Oplossen

### Probleem: "fatal: not a git repository"

**Oplossing:**
```bash
cd /var/www/html
git init
```

### Probleem: "error: failed to push"

**Oplossing:**
- Check of remote repository bestaat
- Check of je toegang hebt
- Check of je commits hebt gemaakt

### Probleem: Website werkt niet meer

**Oplossing:**
1. Check webserver configuratie:
   ```bash
   grep -r "AdalyaPoint\|Adalyapoint" /etc/apache2/
   # Of
   grep -r "AdalyaPoint\|Adalyapoint" /etc/nginx/
   ```

2. Check of directory bestaat:
   ```bash
   ls -la /var/www/html/AdalyaPoint/
   ```

3. Check Apache/Nginx error logs:
   ```bash
   tail -f /var/log/apache2/error.log
   # Of
   tail -f /var/log/nginx/error.log
   ```

---

## 📞 Hulp Nodig?

Als je vastloopt:
1. Check de `MONOREPO_UITLEG.md` voor uitgebreide uitleg
2. Check de `SETUP.md` voor setup instructies
3. Vraag in de chat om hulp

---

## ✅ Checklist

- [ ] Git geïnstalleerd
- [ ] Monorepo gekregen (clone of handmatig)
- [ ] AdalyaPoint code op juiste locatie (`/var/www/html/AdalyaPoint/`)
- [ ] Configuratie bestanden bestaan en zijn correct (database.php, app.php)
- [ ] AdalyaPoint toegevoegd aan Git (`git add AdalyaPoint/`)
- [ ] Eerste commit gemaakt
- [ ] Test: `git pull` werkt
- [ ] Website werkt nog steeds
- [ ] Test synchronisatie: wijziging op VPS2, pull op VPS1

**Als alles vinkjes heeft: Klaar! 🎉**
